[comment {-*- tcl -*- doctools manpage}]
[comment "Modifications by IDG, March 2012"]
[manpage_begin pdf4tcl n 0.9.4]
[copyright {2007-2016 Peter Spjuth}]
[copyright {2009 Yaroslav Schekin}]
[moddesc   {Pdf document generation}]
[titledesc {Pdf document generation}]
[require Tcl 8.6]
[require pdf4tcl [opt 0.9.4]]
[description]

This package provides a container class for generating [term {pdf}] documents.

[section COORDINATES]

All coordinates and distances can be expressed with or without a unit. See
[sectref UNITS] for valid units.
When the page is configured with [option -orient] set to false, origin is in
the bottom left corner. With [option -orient] true (the default), origin is in the top left
corner.
Origin is displaced to account for margins, i.e. if margins are 100,
the user coordinate (0,0) corresponds to (100,100) on the paper.
Page option [option -orient] can also affect the anchor point for things like
images.

[section UNITS]
Any coordinates and distances can be expressed with or without an explicit
unit.  If no unit is given, the default unit for the document is used.
A unit may be one of
[option "mm"] (millimeter),
[option "m"] (millimeter),
[option "cm"] (centimeter),
[option "c"] (centimeter),
[option "p"] (points) or
[option "i"] (inches).

Commands returning coordinates or distances always return a double value
in the document's default unit.

[section {PUBLIC API}]

[subsection {PACKAGE COMMANDS}]

[list_begin definitions]

[call [cmd ::pdf4tcl::new] [arg objectName] [opt [arg "option value"]...]]

This command creates a new pdf4tcl object with an associated Tcl
command whose name is [arg objectName]. This [term object] command is
explained in full detail in the sections [sectref {OBJECT COMMAND}]
and [sectref {OBJECT METHODS}]. The object command will be created
under the current namespace if the [arg objectName] is not fully
qualified, and in the specified namespace otherwise.
If [arg objectName] is %AUTO% a name will generated.
The return value is the newly created object's name.

[para]

The options and their values coming after the name of the object are
used to set the initial configuration of the object.
See [sectref {OBJECT CONFIGURATION}].


[call [cmd ::pdf4tcl::getPaperSize] [arg "paper"]]

This call returns the size of a named paper type, e.g. "a4".
Paper names are case insensitive.
The argument [arg "paper"] may also be a two element list
with values as accepted by [cmd ::pdf4tcl::getPoints].
The return value is a list with width and height in points.


[call [cmd ::pdf4tcl::getPaperSizeList]]

This call returns the list of known paper types.


[call [cmd ::pdf4tcl::getPoints] [arg "val"]]

This call translates a measurement to points (1/72 inch).
The format of [arg "val"] is '[arg "num"] [opt [arg "unit"]]' where
[arg "num"] is a valid integer or double. See [sectref UNITS] for valid
[arg "unit"]s.  If no [arg "unit"] is given, the value is interpreted
as points.


[call [cmd ::pdf4tcl::loadBaseTrueTypeFont] [arg "basefontname"] [arg "ttf_file_name"]]

This call loads a TTF font from file to be used by any pdf4tcl objects.
The [arg "basefontname"] is used to reference this font.
To use this base font in documents, a font with some encoding must be
created from it using [cmd createFont] or [cmd createFontSpecEnc].


[call [cmd ::pdf4tcl::createBaseTrueTypeFont] [arg "basefontname"] [arg "ttf_data"]]

This call creates a base font from TTF binary data.


[call [cmd ::pdf4tcl::loadBaseType1Font] [arg "basefontname"] [arg "AFM_file_name"] [arg "PFB_file_name"]]

This call loads a Type1 font from two files (.afm and .pfb) to be used by
any pdf4tcl objects. The [arg "basefontname"] is used to reference this font.
To use this base font in documents, a font with some encoding must be
created from it using [cmd createFont] or [cmd createFontSpecEnc].


[call [cmd ::pdf4tcl::createBaseType1Font] [arg "basefontname"] [arg "AFM_data"] [arg "PFB_data"]]
 
This call creates a base font from AFM text and PFB binary data.


[call [cmd ::pdf4tcl::createFont] [arg "basefontname"] [arg "fontname"] [arg "encoding_name"]]

This call creates a font that can be used in documents from a base font. The given encoding
defines the (up to) 256 unicode characters that can be drawn when [arg "fontname"] is selected.
To use more characters, multiple fonts need to be created and selected based on what needs to be written.

[comment "String map is used here to be able to include backslash-nl in the example"]
[example [string map {% \\} {
pdf4tcl::loadBaseTrueTypeFont BaseArial "arial.ttf"
pdf4tcl::createFont BaseArial MyArial cp1251 
pdf4tcl::loadBaseType1Font BaseType1 "a010013l.afm" "a010013l.pfb"
pdf4tcl::createFont BaseType1 MyType1 cp1251 
pdf4tcl::new mypdf -paper a4 -compress 0
mypdf startPage
mypdf setFont 10 MyArial
set txt "\u042D\u0442\u043E \u0442\u0435\u043A\u0441\u0442 \u043D\u0430 \u0440\u0443\u0441\u0441\u043A\u043E\u043C%
         \u044F\u0437\u044B\u043A\u0435. This is text in Russian."
mypdf text $txt -bg #CACACA -x 50 -y 100
mypdf setFont 10 MyType1
mypdf text $txt -x 50 -y 200
mypdf write -file fonts.pdf
mypdf destroy
}]]

[call [cmd ::pdf4tcl::createFontSpecEnc] [arg "basefontname"] [arg "fontname"] [arg "subset"]]

This call creates a font that can be used in documents from a base font.
The [arg "subset"] must be a list of (up to 256) unicode values which are the characters that can be
drawn when [arg "fontname"] is selected.

[example {
pdf4tcl::loadBaseTrueTypeFont BaseArial "arial.ttf"
# Subset is a list of unicodes:
for {set f 0} {$f < 128} {incr f} {lappend subset $f}
lappend subset [expr 0xB2] [expr 0x3B2]
pdf4tcl::createFontSpecEnc BaseArial MyArial $subset 
pdf4tcl::new mypdf -paper a4
mypdf startPage
mypdf setFont 16 MyArial
set txt "sin\u00B2\u03B2 + cos\u00B2\u03B2 = 1"
mypdf text $txt -x 50 -y 100
mypdf write -file specenc.pdf
mypdf destroy
}]

[call [cmd ::pdf4tcl::getFonts]]

This call returns the list of known font names, i.e. those accepted in a call
to [method setFont].
This includes the default fonts and fonts created by e.g.
[cmd ::pdf4tcl::createFont].

[call [cmd ::pdf4tcl::rgb2Cmyk] [arg "rgb"]]

This call translates an RGB color value to a CMYK color value.
It is used internally if [option -cmyk] was set at object creation to 
translate colors.
You can redefine this procedure to provide your own translation.

[call [cmd ::pdf4tcl::cmyk2Rgb] [arg "cmyk"]]

This call translates a CMYK color value to an RGB color value.
It is used internally to translate colors.
You can redefine this procedure to provide your own translation.

[call [cmd ::pdf4tcl::catPdf] [arg "infile"] [opt [arg "infile ..."]] [arg "outfile"]]

This call concatenates PDF files into one.
Currently the implementation limits the PDFs a lot since not all details
are taken care of yet. Straightforward ones like those created with pdf4tcl
or ps2pdf should work mostly ok.

[call [cmd ::pdf4tcl::getForms] [arg "infile"]]

This call extracts form data from a PDF file.
The return value is a dictionary with id/info pairs.
The id is the one set with [arg -id] to [method addForm], if the PDF
was generated with pdf4tcl.
The info is a dictionary with the following fields:

[list_begin options]
[opt_def type] Field type.
[opt_def value] Form value.
[opt_def flags] Value of form flags field.
[opt_def default] Default value, if any.
[list_end]

[list_end]

[subsection {OBJECT COMMAND}]

All commands created by [cmd ::pdf4tcl::new] have the following
general form and may be used to invoke various operations on their
pdf object.

[list_begin definitions]

[call [cmd objectName] [method method] [opt [arg "arg arg ..."]]]

The method [method method] and its [arg arg]'uments determine the exact
behavior of the command. See section [sectref {OBJECT METHODS}] for
the detailed specifications.

[list_end]


[subsection {OBJECT METHODS}]

[list_begin definitions]

[call [arg objectName] [method configure]]

The method returns a list of all known options and their current
values when called without any arguments.


[call [arg objectName] [method configure] [arg option]]

The method behaves like the method [method cget] when called with a
single argument and returns the value of the option specified by said
argument.


[call [arg objectName] [method configure] [option -option] [arg value]...]

The method reconfigures the specified [option option]s of the object,
setting them to the associated [arg value]s, when called with an even
number of arguments, at least two.

[para]

The legal options are described in the section
[sectref {OBJECT CONFIGURATION}].


[call [arg objectName] [method cget] [option -option]]

This method expects a legal configuration option as argument and will
return the current value of that option for the object the method was
invoked for.

[para]

The legal configuration options are described in section
[sectref {OBJECT CONFIGURATION}].


[call [arg objectName] [method destroy]]

This method destroys the object it is invoked for.
If the [option -file] option was given at object creation,
the output file will be finished and closed.


[call [arg objectName] [method startPage] [opt [arg "option value"]...]]

This method starts a new page in the document. The page will have the
default page settings for the document unless overridden by [arg "option"].
See [sectref {PAGE CONFIGURATION}] for page settings.
This will end any ongoing page.

[call [arg objectName] [method endPage]]

This method ends a page in the document.  It is normally not needed since
it is implied by e.g. [method startPage] and [method finish].  However,
if the document is built page by page in e.g. an event driven environment
it can be good to call [method endPage] explicitly to have all the page's
work finished before reentering the event loop.

[call [arg objectName] [method startXObject] [opt [arg "option value"]...]]

This method starts a new XObject in the document.  An XObject is a reusable
drawing object and behaves just like a page where you can draw any graphics.
An XObject must be created between pages and this method will end any ongoing
page. The return value is an id that can be used with [method putImage] to draw
it on the current page or with some forms.
All page settings ([sectref {PAGE CONFIGURATION}]) are
valid when creating an XObject. Default options are
[option -paper] = {100p 100p}, [option -landscape] = 0,
[option -orient] = document default, [option -margin]= 0.

[list_begin options]

[opt_def -noimage [arg bool]]
If this is set the XObject is not added to the image resource set and cannot
be used with putImage, only in forms. The XObject also gets access to resources
which is needed to use e.g. fonts within the XObject. This behaviour has shown
to be PDF reader dependent, and it is currently not known if this can be
made to work better.

[list_end]

[call [arg objectName] [method endXObject]]

This method ends an XObject definition. It works just like [method endPage].

[call [arg objectName] [method finish]]

This method ends the document.
This will do [method endPage] if needed.
If the [option -file] option was given at object creation,
the output file will be finished and closed.

[call [arg objectName] [method get]]

This method returns the generated pdf.
This will do [method endPage] and [method finish] if needed.
If the [option -file] option was given at object creation, nothing is returned.

[call [arg objectName] [method write] [opt [arg "-file filename"]]]

This method writes the generated pdf to the given [arg "filename"].
If no [arg "filename"] is given, it is written to stdout.
This will do [method endPage] and [method finish] if needed.
If the [option -file] option was given at object creation, an empty file
is created.

[call [arg objectName] [method addForm] [arg "type"] [arg "x"] [arg "y"] [arg "width"] [arg "height"] [opt [arg "option value"]...]]
Add an interactive form at the given position and size. Supported types are [arg text] and [arg checkbutton].
Option [arg "-init"] gives an initial value for the form.
Option [arg "-id"] gives the form an ID that must be unique within a document. If not given, one will be generated.
For a text, option [arg "-multiline"] enables multi line editing.
For a checkbutton, options [arg "-on"] and [arg "-off"] can be given an xobject (created with [method startXObject]) to control its appearance.

[list_end]

[subsection {OBJECT METHODS, PAGE}]

[list_begin definitions]

[call [arg objectName] [method getDrawableArea]]

This method returns the size of the available area on the page,
after removing margins.  The return value is a list of width and height,
in the document's default unit.

[call [arg objectName] [method canvas] [arg "path"] [opt [arg "option value"]...]]

Draws the contents of the canvas widget [arg "path"] on the current page.
The return value is the bounding box in pdf page coordinates of the area covered.
Option [arg "-bbox"] gives the area of the canvas to be drawn. Default is
the entire contents, i.e. the result of $path bbox all.
Options [arg "-x"], [arg "-y"], [arg "-width"] and [arg "-height"] defines
an area on the page where to place the contents. Default area starts at origin,
stretching over the drawable area of the page.
Option [arg "-sticky"] defines how to place the contents within the area.
The area is always filled in one direction, preserving aspect ratio, unless
[arg "-sticky"] defines that the other direction should be filled too.  Default
[arg "-sticky"] is [arg "nw"].
If option [arg "-bg"] is true, a background is drawn in the canvas' background
color.  Otherwise only objects are drawn.  Default is false.
Option [arg "-fontmap"] gives a dictionary mapping from Tk font names to PDF font names.
Option [arg "-textscale"] overrides the automatic downsizing made for tk::canvas text items that are deemed too large. If [arg "-textscale"] is larger than 1, all text items are reduced in size by that factor.
[para]
Fonts:
[para]
If no font mapping is given, fonts for text items are limited to PDF's
builtins, i.e. Helvetica, Times and Courier. A guess is made to chose which
one to use to get a reasonable display on the page.
[para]
An element in a font mapping must exactly match the -font option in the
text item. The corresponding mapping value is a PDF font family, e.g. one
created by [cmd pdf4tcl::createFont], possibly followed by a size.
It is recommended to use named fonts
in Tk to control the font mapping in detail.
[para]
Limitations:
[para]
Option -splinesteps for lines/polygons is ignored.
[para]
Stipple offset is limited. The form x,y should work.
[para]
Window items require Img to be present and must be visible on-screen when
the canvas is drawn.

[call [arg objectName] [method metadata] [opt [arg "option value"]...]]

This method sets metadata fields for this document.  Supported field options are
 [arg -author], [arg -creator], [arg -keywords], [arg -producer], [arg -subject],
  [arg -title], [arg -creationdate] and [arg -format].

[call [arg objectName] [method bookmarkAdd] [opt [arg "option value"]...]]

Add a bookmark on the current page.

[list_begin options]

[opt_def -title [arg text]]
Set the text of the bookmark.

[opt_def -level [arg level]]
Set the level of the bookmark. Default is 0.

[opt_def -closed [arg boolean]]
Select if the bookmark is closed by default. Default is false, i.e. not closed.

[list_end]

[call [arg objectName] [method embedFile] [arg "filename"] [opt [arg "option value"]...]]

This method embeds a file into the PDF stream. File data is considered binary. Returns an id that can be used in subsequent calls to [method attachFile].

[list_begin options]

[opt_def -id [arg id]]
Explicitly select an id for the file. The [arg "id"] must be unique within the document.

[opt_def -contents [arg data]]
Provides the file contents instead of reading the actual file.
[list_end]

[call [arg objectName] [method attachFile] [arg "x"] [arg "y"] [arg "width"] [arg "height"] [arg "fid"] [arg "description"] [opt [arg "option value"]...]]

This method adds a file annotation to the current page. The location of the file annotation is given by the coordinates [arg "x"], [arg "y"], [arg "width"], [arg "height"]. The annotation is rendered by default as a paperclip icon, which allows the extraction of the attached file. An [arg "fid"] from a previous call to [method embedFile] must be set as well as a [arg "description"], which is shown by the PDF viewer upon activating the annotation.

[list_begin options]

[opt_def -icon [arg icon]]
Controls the appearance of the attachment. Valid values are Paperclip, Tag, Graph, or PushPin. Default value is Paperclip.

[list_end]

[example {
set fid [$pdfobject embedFile "data.txt" -contents "This should be stored in the file."]
$pdfobject attachFile 0 0 100 100 $fid "This is the description"
}]

[list_end]

[subsection {OBJECT METHODS, TEXT}]

[list_begin definitions]

[call [arg objectName] [method setFont] [arg "size"] [opt [arg "fontname"]]]

This method sets the font used by text drawing routines. If [arg "fontname"]
is not provided, the previously set [arg "fontname"] is kept.

[call [arg objectName] [method getStringWidth] [arg "str"]]

This method returns the width of a string under the current font.

[call [arg objectName] [method getCharWidth] [arg "char"]]

This method returns the width of a character under the current font.

[call [arg objectName] [method setTextPosition] [arg "x"] [arg "y"]]

Set coordinate for next text command.

[call [arg objectName] [method moveTextPosition] [arg "dx"] [arg "dy"]]

Increment position by [arg "dx"], [arg "dy"] for the next text command.

[call [arg objectName] [method getTextPosition]]

This method returns the current text coordinate.

[call [arg objectName] [method newLine] [opt [arg spacing]]]

Moves text coordinate down and resets x to where the latest
[method setTextPosition] was. The number of lines to move down can
be set by [arg spacing]. This may be any real number, including negative,
and defaults to the value set by [method setLineSpacing].

[call [arg objectName] [method setLineSpacing] [arg spacing]]

Set the default line spacing used be e.g. [method newLine].  Initially
the spacing is 1.

[call [arg objectName] [method getLineSpacing]]

Get the current default line spacing.

[call [arg objectName] [method text] [arg "str"] [opt [arg "option value"]...]]

Draw text at the position defined by setTextPosition using the font defined by 
setFont.
   [list_begin options]
      [opt_def -align "[arg left|right|center]   (default left)"]
      [opt_def -angle "[arg degrees]   (default 0) - Orient string at the specified angle."]  
      [opt_def -xangle "[arg degrees]   (default 0)"]
      [opt_def -yangle "[arg degrees]   (default 0) - Apply x or y shear to the text."]
      [opt_def -x "[arg x]   (default 0)"]
      [opt_def -y "[arg y]   (default 0) - Allow the text to be positioned without setTextPosition."]
      [opt_def -bg "[arg bool]   (default 0)"]
      [opt_def -background "[arg bool]   (default 0)"]
      [opt_def -fill "[arg bool]   (default 0) "]
         Any of [option -bg], [option -background] or [option -fill] cause the text to be drawn 
         on a background whose color is set by setBgColor.
   [list_end]


[call [arg objectName] [method drawTextBox] [arg "x"] [arg "y"] [arg "width"] [arg "height"] [arg "str"] [opt [arg "option value"]...]]

Draw the text string [arg "str"] wrapping at blanks and tabs so that it fits within the box defined
by [arg "x"], [arg "y"], [arg "width"] and [arg "height"]. An embedded newline in [arg "str"] causes
a new line in the output. If [arg "str"] is too long to fit in the specified box, it is truncated and the unused remainder is returned.
   [list_begin options]
      [opt_def -align "[arg left|right|center|justify]"]
         Specifies the justification. If not given, the text is left justified.
      [opt_def -linesvar "[arg var]"]
         Gives the name of a variable which will be set to the number of lines written.
      [opt_def -dryrun "[arg bool]"]
         If true, no changes will be made to the PDF document. The return
         value and [option -linesvar] gives information of what would happen
         with the given text.
   [list_end]


[call [arg objectName] [method getFontMetric] [arg "metric"]]

Get information about current font. The available [arg "metric"]s are
[option ascend], [option descend], [option fixed], [option bboxb],
[option bboxt] and [option height].

[list_begin options]

[opt_def ascend]
Top of typical glyph, displacement from anchor point. Typically a positive number since it is above the anchor point.
[opt_def descend]
Bottom of typical glyph, displacement from anchor point. Typically a negative number since it is below the anchor point.
[opt_def fixed]
Boolean which is true if this is a fixed width font.
[opt_def bboxb]
Bottom of Bounding Box, displacement from anchor point. Typically a negative number since it is below the anchor point.
[opt_def bboxt]
Top of Bounding Box, displacement from anchor point. Typically a positive number since it is above the anchor point.
[opt_def height]
Height of font's Bounding Box.

[list_end]

[list_end]

[subsection {OBJECT METHODS, IMAGES}]

A limited set of image formats are directly understood by pdf4tcl,
currently some JPEG, some PNG, and some TIFF formats.
To use unsupported formats, use Tk and the Img
package to load and dump images to raw format which can be fed to
[method putRawImage] and [method addRawImage].

[list_begin definitions]

[call [arg objectName] [method putImage] [arg "id"] [arg "x"] [arg "y"] [opt [arg "option value"]...]]

Put an image on the current page. The image must have been added previously by
[method addImage] or [method addRawImage]. The [arg "id"] is the one returned
from the add command.

[list_begin options]

[opt_def -angle [arg degrees]]
Rotate image [arg degrees] counterclockwise around the anchor point.
Default is 0.

[opt_def -anchor [arg anchor]]
Set the anchor point (nw, n, ne etc.) of the image.
Coordinates [arg "x"] and [arg "y"] places the anchor point, and any rotation is around the anchor point.
Default is nw if [option -orient] is true, otherwise se.

[opt_def -height [arg height]]
Set the height of the image.  Default height is one point per pixel.  If [arg width] is set but not [arg height],
the height is selected to preserve the aspect ratio of the image.

[opt_def -width [arg width]]
Set the width of the image.  Default width is one point per pixel.
If [arg height] is set but not [arg width], the width is selected to
preserve the aspect ratio of the image.

[list_end]

[call [arg objectName] [method putRawImage] [arg "data"] [arg "x"] [arg "y"]  [opt [arg "option value"]...]]
Put an image on the current page. Works like [method putImage] except that the raw image data is given directly.

[list_begin options]

[opt_def -compress [arg boolean]]
Raw data will be zlib compressed if this option is set to true.
Default value is the document's [option -compress] setting.

[list_end]

[example {
  image create photo img1 -file image.gif
  set imgdata [img1 data]
  mypdf putRawImage $imgdata 60 20 -height 40
}]

[call [arg objectName] [method addImage] [arg "filename"] [opt [arg "option value"]...]]

Add an image to the document. Returns an id that can be used in subsequent
calls to [method putImage]. Supported formats are PNG, JPEG and TIFF.
[list_begin options]

[opt_def -id [arg id]]
Explicitly select an id for the image. The [arg "id"] must be unique within the document.

[opt_def -type [arg name]]
Set the image type.  This can usually be deduced from the file name, this
option helps when that is not possible.  This can be either "png", "jpeg",
or "tiff".
[list_end]

[call [arg objectName] [method addRawImage] [arg "data"] [opt [arg "option value"]...]]
Add an image to the document. Works like [method addImage] except that the raw image data is given directly.

[list_begin options]

[opt_def -compress [arg boolean]]
Raw data will be zlib compressed if this option is set to true.
Default value is the document's [option -compress] setting.

[list_end]

[example {
  image create photo img1 -file image.gif
  set imgdata [img1 data]
  set id [mypdf addRawImage $imgdata]
  mypdf putImage $id 20 60 -width 100
}]

[call [arg objectName] [method getImageHeight] [arg "id"]]

This method returns the height of the image identified by [arg "id"].

[call [arg objectName] [method getImageSize] [arg "id"]]

This method returns the size of the image identified by [arg "id"].  The
return value is a list of width and height.

[call [arg objectName] [method getImageWidth] [arg "id"]]

This method returns the width of the image identified by [arg "id"].

[list_end]

[subsection {OBJECT METHODS, COLORS}]

Colors can be expressed in various formats. First, as a three element list
of values in the range 0.0 to 1.0. Second, in the format #XXXXXX where
the Xes are two hexadecimal digits per color value.  Third, if Tk is available,
any color accepted by winfo rgb is accepted.

[list_begin definitions]

[call [arg objectName] [method setBgColor] [arg "red"] [arg "green"] [arg "blue"]]
Sets the background color for text operations where -bg is true.

[call [arg objectName] [method setBgColor] [arg "c"] [arg "m"] [arg "y"] [arg "k"]]
Alternative calling form, to set color in CMYK color space.

[call [arg objectName] [method setFillColor] [arg "red"] [arg "green"] [arg "blue"]]
Sets the fill color for graphics operations, and the foreground color for
text operations.

[call [arg objectName] [method setFillColor] [arg "c"] [arg "m"] [arg "y"] [arg "k"]]
Alternative calling form, to set color in CMYK color space.

[call [arg objectName] [method setStrokeColor] [arg "red"] [arg "green"] [arg "blue"]]
Sets the stroke color for graphics operations.

[call [arg objectName] [method setStrokeColor] [arg "c"] [arg "m"] [arg "y"] [arg "k"]]
Alternative calling form, to set color in CMYK color space.

[list_end]

[subsection {OBJECT METHODS, GRAPHICS}]

[list_begin definitions]

[call [arg objectName] [method setLineWidth] [arg "width"]]
   Sets the width for subsequent line drawing.
   Line width must be a non-negative number.

[call [arg objectName] [method setLineDash] [opt [arg "on off"]...] [opt [arg "offset"]]]
   Sets the dash pattern for subsequent line drawing.
   Offset and any elements in the dash pattern must be non-negative numbers.
   [emph "on off"] is a series of pairs of numbers which define a 
   dash pattern. The 1st, 3rd ... numbers give units to paint, 
   the 2nd, 4th ... numbers specify unpainted gaps. When all numbers have 
   been used, the pattern is re-started from the beginning. 
   An optional last argument sets the dash offset, which defaults to 0.
   Calling [method setLineDash] with no arguments resets the dash pattern
   to a solid line.

[call [arg objectName] [method setLineStyle] [arg "width"] [arg "args"]]
   Sets the width and dash pattern for subsequent line drawing.
   Line width and any elements in the dash pattern must be non-negative numbers.
   [emph "args"] is a series of numbers (not a tcl list) which define a 
   dash pattern. The 1st, 3rd ... numbers give units to paint, 
   the 2nd, 4th ... numbers specify unpainted gaps. When all numbers have 
   been used, the pattern is re-started from the beginning. 
   This method do not support offsetting the pattern, see [method setLineDash]
   for a more complete method.

[call [arg objectName] [method line] [arg "x1"] [arg "y1"] [arg "x2"] [arg "y2"]]
   Draws a line from [emph "x1,"] [emph "y1"] to [emph "x2,"] [emph "y2"]

[call [arg objectName] [method curve] [arg "x1"] [arg "y1"] [arg "x2"] [arg "y2"]\
   [arg "x3"] [arg "y3"] [opt [arg "x4 y4"]] ]
   If [emph "x4,"] [emph "y4"] are present, draws a cubic bezier from [emph "x1,"]
   [emph "y1"] to [emph "x4,"] [emph "y4"] with control points [emph "x2,"] [emph "y2"] and
   [emph "x3,"] [emph "y3"]. Otherwise draws a quadratic bezier from [emph "x1,"]
   [emph "y1"] to [emph "x3,"] [emph "y3"], with control point [emph "x2,"]
   [emph "y2"]

[call [arg objectName] [method polygon] [opt [arg "x y"]...] [opt [arg "option value"]...]]
   Draw a polygon. There must be at least 3 points.
   The polygon is closed back to the first coordinate unless [arg -closed] is false in which case a poly-line is drawn.
   [list_begin options]
      [opt_def -filled "[arg bool]   (default 0)"]
      Fill the polygon.
      [opt_def -stroke "[arg bool]   (default 1)"]
      Draw an outline of the polygon.
      [opt_def -closed "[arg bool]   (default 1)"]
      Close polygon.
   [list_end]

[call [arg objectName] [method circle] [arg "x"] [arg "y"] [arg "radius"] [opt [arg "option value"]...]]
   Draw a circle at the given center coordinates.
   [list_begin options]
      [opt_def -filled "[arg bool]   (default 0)"]
      Fill the circle.
      [opt_def -stroke "[arg bool]   (default 1)"]
      Draw an outline of the circle.
   [list_end]

[call [arg objectName] [method oval] [arg "x"] [arg "y"] [arg "radiusx"] [arg "radiusy"] [opt [arg "option value"]...]]
   Draw an oval at the given center coordinates.
   [list_begin options]
      [opt_def -filled "[arg bool]   (default 0)"]
      Fill the oval.
      [opt_def -stroke "[arg bool]   (default 1)"]
      Draw an outline of the oval.
   [list_end]

[call [arg objectName] [method arc] [arg "x"] [arg "y"] [arg "radiusx"] [arg "radiusy"] [arg "phi"] [arg "extend"] [opt [arg "option value"]...]]
   Draw an arc, following the given oval. The arc starts at angle [arg "phi"], given in degrees starting in the "east" direction, counting counter clockwise. The arc extends [arg "extend"] degrees.
   [list_begin options]
      [opt_def -filled "[arg bool]   (default 0)"]
      Fill the arc.
      [opt_def -stroke "[arg bool]   (default 1)"]
      Draw an outline of the arc.
      [opt_def -style "[arg arc|pieslice|chord]   (default [arg arc])"]
      Defines the style of the arc. An [arg "arc"] draws the perimeter of the arc and is never filled. A [arg "pieslice"] closes the arc with lines to the center of the oval. A [arg "chord"] closes the arc directly.
   [list_end]

[call [arg objectName] [method arrow] [arg "x1"] [arg "y1"] [arg "x2"] [arg "y2"] [arg "size"] [opt [arg "angle"]]]
   Draw an arrow. Default [arg "angle"] is 20 degrees.

[call [arg objectName] [method rectangle] [arg "x"] [arg "y"] [arg "width"] [arg "height"] [opt [arg "option value"]...]]
   Draw a rectangle.
   [list_begin options]
      [opt_def -filled "[arg bool]   (default 0)"]
      Fill the rectangle.
      [opt_def -stroke "[arg bool]   (default 1)"]
      Draw an outline of the rectangle.
   [list_end]

[call [arg objectName] [method clip] [arg "x"] [arg "y"] [arg "width"] [arg "height"]]
   Create a clip region. To cancel a clip region you must restore a graphic context that was saved before.

[call [arg objectName] [method gsave]]
   Save graphic/text context. (I.e. insert a raw PDF "q" command).
This saves the settings of at least these calls: [method clip], [method setBgColor], [method setFillColor], [method setStrokeColor], [method setLineStyle], [method setLineWidth], [method setLineDash], [method setFont], and [method setLineSpacing].
   Each call to [method gsave] should be followed by a later call to [method grestore] in the same page.

[call [arg objectName] [method grestore]]
   Restore graphic/text context. (I.e. insert a raw PDF "Q" command).

[list_end]


[subsection {OBJECT CONFIGURATION}]

All pdf4tcl objects understand the options from [sectref {PAGE CONFIGURATION}],
which defines default page settings when used with a pdf4tcl object.
The objects also understand the following configuration options:

[list_begin options]

[opt_def -cmyk [arg boolean]]

If true, pdf4tcl will try to generate the document in CMYK color space.
See [cmd ::pdf4tcl::rgb2Cmyk] for a way to control color translation.
Default value is false.
This option can only be set at object creation.

[opt_def -compress [arg boolean]]

Pages will be zlib compressed if this option is set to true.
Default value is true.
This option can only be set at object creation.

[opt_def -file [arg filename]]

Continuously write pdf to [arg filename] instead of storing it
in memory.
This option can only be set at object creation.

[opt_def -unit [arg defaultunit]]

Defines default unit for coordinates and distances.  Any value given without
a unit is interpreted using this unit.  
See [sectref UNITS] for valid units.
Default value is "p" as in points.
This option can only be set at object creation.

[list_end]

[subsection {PAGE CONFIGURATION}]

[list_begin options]

[opt_def -paper [arg name]]

The argument of this option defines the paper size.
The paper size may be a string like "a4", where valid values
are available through [cmd ::pdf4tcl::getPaperSizeList].
Paper size may also be a two element list specifying width and height.
[para]
The default value of this option is "a4".

[opt_def -landscape [arg boolean]]

If true, paper width and height are switched.
[para]
The default value of this option is false.

[opt_def -orient [arg boolean]]

This sets the orientation of the y axis of the coordinate system.
With [option -orient] false, origin is in the bottom left corner.
With [option -orient] true, origin is in the top left corner.
[para]
The default value of this option is true.

[opt_def -margin [arg values]]

The margin is a one, two or four element list of margins.
For one element, it specifies all margins.
Two elements specify left/right and top/bottom.
Four elements specify left, right, top and bottom.
[para]
The default value of this option is zero.

[opt_def -rotate [arg angle]]

This value defines a rotation angle for the display of the page.
Allowed values are multiples of 90.
[para]
The default value of this option is zero.

[list_end]

[section EXAMPLES]
[example_begin]
  pdf4tcl::new mypdf -paper a3
  mypdf startPage
  mypdf setFont 12 Courier
  mypdf text "Hejsan" -x 50 -y 50
  mypdf write -file mypdf.pdf
  mypdf destroy
[example_end]

[see_also doctools]
[keywords pdf document]
[manpage_end]
